@echo off
setlocal

if not %1 == "" goto using

:usage

echo.
echo LoopFile.bat
echo zachd 3/01/2021
echo This is a quick and dirty front-end script to the adxencd front-end to the CRI ADX encoder.
echo Usage is LoopFile ADXNAME , as in LoopFile ADX_MENU
echo LoopFile will then look for ADX_MENU.wav and encode it to a looping ADX_MENU.adx for use in Dreamcast/PS2 games
echo.
echo No need to run this directly: just run ConvertAll.bat
echo.
pause

goto done

:using

REM adxencd expects to operate out of the current directory only, so make sure we're there
pushd %~dp1

REM eliminate any .WAV filename extension
set JUSTNAME=%~n1


if exist temp-output.txt echo File 'temp-output.txt' found: please delete this before continuing.&goto done
if exist temp-samples.txt echo File 'temp-samples.txt' found: please delete this before continuing.&goto done
if not exist "%JUSTNAME%.wav" echo WAV file '%JUSTNAME%.wav' not found: skipping.&goto done

echo Doing a first-pass encode to figure out the sample count...

adxencd.exe "%JUSTNAME%.wav" 2> temp-output.txt

echo.

findstr Input.audio.sample temp-output.txt > temp-samples.txt

echo OK, now doing a second encode except this time we'll loop the file...

for /f "tokens=1,2,3,4,5" %%a in (temp-samples.txt) do @adxencd.exe "%JUSTNAME%.wav" -lps0 -lpe%%e 2>NUL

echo.

echo Encode complete: %JUSTNAME%.adx is now looped

echo Now renaming the ADX to BIN...
move /Y "%JUSTNAME%.adx" "%JUSTNAME%.bin" >NUL

del temp-output.txt 2>NUL
del temp-samples.txt 2>NUL

echo.

if exist "%JUSTNAME%.bin" echo Conversion of %JUSTNAME%.wav to the looped ADX file %JUSTNAME%.bin is complete.
if not exist "%JUSTNAME%.bin" echo Unknown error occurred. Sorry.

echo.

popd

:done
