import os
import sys
import wave
import math
import struct
from struct import pack
from struct import unpack
from array import array
from enum import Enum

# This is quick and dirty.

# Syntax is three filenames:
	# transplant NAOMI_WAVE_FILE STEAM_WAVE_FILE OUTPUT_COMBINED_WAVE_FILE
# I used subfolders so that I could do it quickly.
	# While in the NAOMI_FILES_FOLDER:
	# for %a in (mvc*) do ..\transplant.py %a ..\Untouched\%a ..\Output\%a

# ==============================================================================================
if __name__ == '__main__':
	argv = sys.argv
	argc = len(argv)

	if argc != 4:
		print ('Usage: transplant <source_audio_wav> <steam_wav> <outputfile>')
		print ('Invalid arguments: exiting')
		sys.exit()	

	sourceFile = argv[1]
	templateFile = argv[2]
	destFile = argv[3]

	print ('args: source %s, steam version %s, dest %s' % (sourceFile, templateFile, destFile))

	sourceBytes = array('B', open(sourceFile, 'rb').read())
	sourceStats = os.stat(sourceFile)

	# RIFF | file size | WAVE | [ fourcc / chunksize / data ]
	chunkOffset = 0x0c

	print ('Source audio data from \'%s\':' % (sourceFile))
	
	dataChunkLen = 0
	dataChunkLenOffset = 0

	while (chunkOffset < sourceStats.st_size):
		chunkData = sourceBytes[chunkOffset:chunkOffset + 4]

		# We just want the first two fmt and data chunks
		# Note that this is brittle and expects 'normal' chunk ordering
		fIsData = ((chunkData[0] == ord('d')) and (chunkData[1] == ord('a')) and (chunkData[2] == ord('t')) and (chunkData[3] == ord('a')))

		if (not ((chunkData[0] == ord('f')) and (chunkData[1] == ord('m')) and (chunkData[2] == ord('t')) and (chunkData[3] == ord(' '))) and
		    (not fIsData)):
			print ('\tGot all we need from source, moving to template...')
			break

		print ('\tfourcc: \'%c%c%c%c\'' % (chunkData[0], chunkData[1], chunkData[2], chunkData[3]))
		chunkData = sourceBytes[chunkOffset + 4:chunkOffset + 8]
		chunkLenAsBytes = int.from_bytes(chunkData, byteorder='little')
		print ('\tchunkLen: 0x%x' % chunkLenAsBytes)

		if fIsData:
			dataChunkLenOffset = chunkOffset + 4
			dataChunkLen = chunkLenAsBytes

		chunkOffset += chunkLenAsBytes + 8

	sourceBytesToCopy = sourceBytes[0:chunkOffset]
	print ('\t\tCopied 0x%x bytes from source' % chunkOffset)

	if (dataChunkLen % 2 == 1):
		trashval = 0
		sourceBytesToCopy += array('B', trashval.to_bytes(1, byteorder='little'))
		print ('\t\t\tWARNING: Adding one byte for padding')
		if (dataChunkLenOffset != 0):
			sourceBytesToCopy[dataChunkLenOffset:dataChunkLenOffset + 4] = array('B', (dataChunkLen + 1).to_bytes(4, byteorder='little'))

	templateBytes = array('B', open(templateFile, 'rb').read())
	templateStats = os.stat(templateFile)

	chunkStart = 0
	chunkOffset = 0x0c
	nChunks = 0

	print ('Copying steam metadata from \'%s\':' % (templateFile))

	while (chunkOffset < templateStats.st_size):
		# Skip the leading fmt and data chunks
		if (nChunks == 2):
			chunkStart = chunkOffset
		
		chunkData = templateBytes[chunkOffset:chunkOffset + 4]
		print ('\tfourcc: \'%c%c%c%c\'' % (chunkData[0], chunkData[1], chunkData[2], chunkData[3]))

		chunkData = templateBytes[chunkOffset + 4:chunkOffset + 8]
		chunkLenAsBytes = int.from_bytes(chunkData, byteorder='little')
		print ('\tchunkLen: 0x%x' % chunkLenAsBytes)
		chunkOffset += chunkLenAsBytes + 8
		nChunks += 1

	templateBytesToCopy = templateBytes[chunkStart:chunkOffset]
	print ('\tCopied 0x%x bytes from template' % (chunkOffset - chunkStart))

	totalFile = sourceBytesToCopy + templateBytesToCopy
	totalFile[0x04:0x08] = array('B', (len(sourceBytesToCopy + templateBytesToCopy) - 8).to_bytes(4, byteorder='little'))

	open(destFile, 'wb').write(totalFile)
	print ('Wrote 0x%x bytes to destination file \'%s\'' % (len(totalFile), destFile))


# ==============================================================================================
